/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.sonarsource.sonarlint.core.client.api.connected.StorageException;

public class ProtobufUtil {
    private ProtobufUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Message> T readFile(Path file, Parser<T> parser) {
        try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
            Message message = (Message)parser.parseFrom(input);
            return (T)message;
        }
        catch (IOException e) {
            throw new StorageException("Failed to read file: " + file, (Throwable)e);
        }
    }

    public static void writeToFile(Message message, Path toFile) {
        try (OutputStream out = Files.newOutputStream(toFile, new OpenOption[0]);){
            message.writeTo(out);
        }
        catch (IOException e) {
            throw new StorageException("Unable to write protocol buffer data to file " + toFile, (Throwable)e);
        }
    }
}

